/* $Id: lintlib.c,v 1.101 1999/01/08 23:58:38 ericb Exp $ */
/* Copyright (C) 1994 - 1998, Hewlett-Packard Company, all rights reserved. */
/* Written by Eric Backus */

/*LINTLIBRARY*/

#include "sema.h"

/* Undocumented functions */
extern SHORTSIZ16 EXPORT e1432_get_cal_failures(E1432ID, SHORTSIZ16,
						LONGSIZ32 *);
extern SHORTSIZ16 EXPORT e1432_get_cal_gain(E1432ID, SHORTSIZ16,
					    FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT e1432_get_cal_gain2(E1432ID, SHORTSIZ16,
					     FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT e1432_get_cal_offset(E1432ID, SHORTSIZ16,
					      FLOATSIZ32 *);
extern SHORTSIZ16 EXPORT e1432_get_cal_offset2(E1432ID, SHORTSIZ16,
					       FLOATSIZ32 *);

/* From rev.c */
const char *_e1432buildId1 = 0;

/* Bogasity needed to calm lint */
#ifdef	HAVE_SIGBUS
jmp_buf i1432_buserr_env = { 0 };
volatile int i1432_buserr_env_valid = 0;
int i1432_buserr_trap = 0;
#endif
#if defined(HAVE_SICL) || defined(HAVE_VTL)
char i1432_sicl_name[E1432_SICL_NAME_MAX] = { 0 };
INST i1432_sicl_id = 0;
SHORTSIZ16 *i1432_a16_base = 0;
#endif
#ifdef	HAVE_SICL
struct i1432_iopen_list_info i1432_iopen_list_info = { 0 };
int i1432_a16_id_index = 0;
int i1432_have_a24_d32 = 0;
int i1432_sicl_imap_count = 0;
#endif
int i1432_lib_init = 0;
E1432_MODULE_LIST_NODE *i1432_mod_list = 0;
int i1432_mod_count = 0;
struct i1432_chan_info *i1432_chan_list[E1432_CHAN_TYPES] = { 0 };
int i1432_chan_count[E1432_CHAN_TYPES] = { 0 };
E1432_GROUP_LIST_NODE *i1432_group_list = 0;
int i1432_trace_level = 0;
int i1432_print_reg_access = 0;
int i1432_print_errors = 0;
char *i1432_error_str = 0;
char *i1432_error_info = 0;
SHORTSIZ16 i1432_dnld_fw_err = 0;
LONGSIZ32 i1432_dnld_fw_state = 0;
const char *i1432_install_file = 0;
SHORTSIZ16 i1432_install_from_mem = 0;
SHORTSIZ16 i1432_diag_print_level = 0;
char i1432_mod_opt_list[E1432_MOD_OPT_LIST_MAX+1] = { 0 };
E1432_DIAG_CONFIG i1432_diag_config = { 0 };

int
main(void)
{
    struct e1432_hwconfig hwconfig;
    SHORTSIZ16 a = 0;
    SHORTSIZ16 b = 0;
    LONGSIZ32 l = 0;
    FLOATSIZ32 f = 0;
    FLOATSIZ64 d = 0;
    E1432ID h = NULL;
    void   *p = NULL;
    int     i = 0;

#ifdef	__DSP96K__
    /* Downloadable-only functions */
    e1432_read_y(NULL, NULL);
    e1432_write_y(NULL, NULL);
    p = *e1432_xy_memcpy(NULL, NULL, 0);
    p = *e1432_yx_memcpy(NULL, NULL, 0);
#endif

    /* Module setups */
    a = e1432_get_anti_alias_digital(h, a, NULL);
    a = e1432_set_anti_alias_digital(h, a, b);
    a = e1432_get_append_status(h, a, NULL);
    a = e1432_set_append_status(h, a, b);
    a = e1432_get_arm_channel(h, a, NULL);
    a = e1432_set_arm_channel(h, a, b);
    a = e1432_get_arm_mode(h, a, NULL);
    a = e1432_set_arm_mode(h, a, b);
    a = e1432_get_arm_time_interval(h, a, NULL);
    a = e1432_get_arm_time_interval_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_arm_time_interval(h, a, f);
    a = e1432_get_auto_group_meas(h, a, NULL);
    a = e1432_set_auto_group_meas(h, a, b);
    a = e1432_get_auto_trigger(h, a, NULL);
    a = e1432_set_auto_trigger(h, a, b);
    a = e1432_get_avg_mode(h, a, NULL);
    a = e1432_set_avg_mode(h, a, b);
    a = e1432_get_avg_number(h, a, NULL);
    a = e1432_get_avg_number_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_avg_number(h, a, l);
    a = e1432_get_avg_update(h, a, NULL);
    a = e1432_get_avg_update_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_avg_update(h, a, l);
    a = e1432_get_avg_weight(h, a, NULL);
    a = e1432_get_avg_weight_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_avg_weight(h, a, l);
    a = e1432_get_blocksize(h, a, NULL);
    a = e1432_get_blocksize_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_blocksize(h, a, l);
    a = e1432_get_cal_dac(h, a, NULL);
    a = e1432_get_cal_dac_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_cal_dac(h, a, b);
    a = e1432_get_cal_voltage(h, a, NULL);
    a = e1432_get_cal_voltage_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_cal_voltage(h, a, f);
    a = e1432_get_calin(h, a, NULL);
    a = e1432_set_calin(h, a, b);
    a = e1432_get_center_freq(h, a, NULL);
    a = e1432_get_center_freq_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_center_freq(h, a, f);
    a = e1432_get_clock_freq(h, a, NULL);
    a = e1432_get_clock_freq_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_clock_freq(h, a, f);
    a = e1432_get_clock_master(h, a, NULL);
    a = e1432_set_clock_master(h, a, b);
    a = e1432_get_clock_source(h, a, NULL);
    a = e1432_set_clock_source(h, a, b);
    a = e1432_get_data_mode(h, a, NULL);
    a = e1432_set_data_mode(h, a, b);
    a = e1432_get_data_port(h, a, NULL);
    a = e1432_set_data_port(h, a, b);
    a = e1432_get_data_size(h, a, NULL);
    a = e1432_set_data_size(h, a, b);
    a = e1432_get_decimation_output(h, a, NULL);
    a = e1432_set_decimation_output(h, a, b);
    a = e1432_get_decimation_oversample(h, a, NULL);
    a = e1432_set_decimation_oversample(h, a, b);
    a = e1432_get_decimation_undersamp(h, a, NULL);
    a = e1432_get_decimation_undersamp_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_decimation_undersamp(h, a, b);
    a = e1432_get_delta_order(h, a, NULL);
    a = e1432_get_delta_order_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_delta_order(h, a, f);
    a = e1432_get_fifo_size(h, a, NULL);
    a = e1432_get_fifo_size_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_fifo_size(h, a, l);
    a = e1432_get_filter_settling_time(h, a, NULL);
    a = e1432_get_filter_settling_time_limits(h, a,NULL, NULL, NULL, NULL);
    a = e1432_set_filter_settling_time(h, a, b);
    a = e1432_get_internal_debug(h, a, NULL);
    a = e1432_get_internal_debug_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_internal_debug(h, a, l);
    a = e1432_get_interrupt_mask(h, a, NULL);
    a = e1432_set_interrupt_mask(h, a, b);
    a = e1432_get_interrupt_priority(h, a, NULL);
    a = e1432_get_interrupt_priority_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_interrupt_priority(h, a, b);
    a = e1432_get_lbus_mode(h, a, NULL);
    a = e1432_set_lbus_mode(h, a, b);
    a = e1432_get_lbus_reset(h, a, NULL);
    a = e1432_reset_lbus(h, a, b);
    a = e1432_get_max_order(h, a, NULL);
    a = e1432_get_max_order_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_max_order(h, a, f);
    a = e1432_get_meas_time_length(h, a, NULL);
    a = e1432_get_meas_time_length_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_meas_time_length(h, a, f);
    a = e1432_get_mmf_delay(h, a, NULL);
    a = e1432_set_mmf_delay(h, a, l);
    a = e1432_get_multi_sync(h, a, NULL);
    a = e1432_set_multi_sync(h, a, b);
    a = e1432_get_octave_avg_mode(h, a, NULL);
    a = e1432_set_octave_avg_mode(h, a, b);
    a = e1432_get_octave_blocksize(h, a, NULL);
    a = e1432_get_octave_hold_mode(h, a, NULL);
    a = e1432_set_octave_hold_mode(h, a, b);
    a = e1432_get_octave_int_time(h, a, NULL);
    a = e1432_get_octave_int_time_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_octave_int_time(h, a, f);
    a = e1432_get_octave_meas(h, a, NULL);
    a = e1432_set_octave_meas(h, a, b);
    a = e1432_get_octave_mode(h, a, NULL);
    a = e1432_set_octave_mode(h, a, b);
    a = e1432_get_octave_start_freq(h, a, NULL);
    a = e1432_get_octave_start_freq_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_octave_start_freq(h, a, f);
    a = e1432_get_octave_stop_freq(h, a, NULL);
    a = e1432_get_octave_stop_freq_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_octave_stop_freq(h, a, f);
    a = e1432_get_octave_time_const(h, a, NULL);
    a = e1432_get_octave_time_const_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_octave_time_const(h, a, f);
    a = e1432_get_octave_time_step(h, a, NULL);
    a = e1432_get_octave_time_step_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_octave_time_step(h, a, f);
    a = e1432_get_overlap(h, a, NULL);
    a = e1432_get_overlap_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_overlap(h, a, l);
    a = e1432_get_peak_decay_time(h, a, NULL);
    a = e1432_get_peak_decay_time_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_peak_decay_time(h, a, f);
    a = e1432_get_peak_hold_time(h, a, NULL);
    a = e1432_get_peak_hold_time_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_peak_hold_time(h, a, l);
    a = e1432_get_peak_mode(h, a, NULL);
    a = e1432_set_peak_mode(h, a, b);
    a = e1432_get_pre_arm_mode(h, a, NULL);
    a = e1432_set_pre_arm_mode(h, a, b);
    a = e1432_get_ramp(h, a, NULL);
    a = e1432_set_ramp(h, a, b);
    a = e1432_get_rms_avg_time(h, a, NULL);
    a = e1432_get_rms_avg_time_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_rms_avg_time(h, a, f);
    a = e1432_get_rms_decay_time(h, a, NULL);
    a = e1432_get_rms_decay_time_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_rms_decay_time(h, a, f);
    a = e1432_get_rms_mode(h, a, NULL);
    a = e1432_set_rms_mode(h, a, b);
    a = e1432_get_hpf_span(h, a, NULL);
    a = e1432_get_hpf_span_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_hpf_span(h, a, f);
    a = e1432_get_peak_span(h, a, NULL);
    a = e1432_get_peak_span_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_peak_span(h, a, f);
    a = e1432_get_rms_span(h, a, NULL);
    a = e1432_get_rms_span_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_rms_span(h, a, f);
    a = e1432_get_sample_mode(h, a, NULL);
    a = e1432_set_sample_mode(h, a, b);
    a = e1432_get_span(h, a, NULL);
    a = e1432_get_span_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_span(h, a, f);
    a = e1432_get_sumbus(h, a, NULL);
    a = e1432_set_sumbus(h, a, b);
    a = e1432_get_trigger_delay(h, a, NULL);
    a = e1432_get_trigger_delay_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_trigger_delay(h, a, l);
    a = e1432_get_trigger_ext(h, a, NULL);
    a = e1432_set_trigger_ext(h, a, b);
    a = e1432_get_trigger_master(h, a, NULL);
    a = e1432_set_trigger_master(h, a, b);
    a = e1432_get_triggers_per_arm(h, a, NULL);
    a = e1432_get_triggers_per_arm_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_triggers_per_arm(h, a, l);
    a = e1432_get_ttltrg_clock(h, a, NULL);
    a = e1432_set_ttltrg_clock(h, a, b);
    a = e1432_get_ttltrg_gclock(h, a, NULL);
    a = e1432_set_ttltrg_gclock(h, a, b);
    a = e1432_get_ttltrg_satrg(h, a, NULL);
    a = e1432_set_ttltrg_satrg(h, a, b);
    a = e1432_get_ttltrg_trigger(h, a, NULL);
    a = e1432_set_ttltrg_trigger(h, a, b);
    a = e1432_set_user_window(h, a, NULL, d);
    a = e1432_get_window(h, a, NULL);
    a = e1432_set_window(h, a, b);
    a = e1432_get_xfer_size(h, a, NULL);
    a = e1432_get_xfer_size_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_xfer_size(h, a, l);
    a = e1432_get_zoom(h, a, NULL);
    a = e1432_set_zoom(h, a, b);

    /* Channel setups */
    a = e1432_get_active(h, a, NULL);
    a = e1432_set_active(h, a, b);
    a = e1432_get_amp_scale(h, a, NULL);
    a = e1432_get_amp_scale_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_amp_scale(h, a, f);
    a = e1432_get_anti_alias_analog(h, a, NULL);
    a = e1432_set_anti_alias_analog(h, a, b);
    a = e1432_get_arm_channel_per_input(h, a, NULL);
    a = e1432_set_arm_channel_per_input(h, a, b);
    a = e1432_get_auto_range_mode(h, a, NULL);
    a = e1432_set_auto_range_mode(h, a, b);
    a = e1432_get_calc_data(h, a, NULL);
    a = e1432_set_calc_data(h, a, b);
    a = e1432_get_coupling(h, a, NULL);
    a = e1432_set_coupling(h, a, b);
    a = e1432_get_coupling_freq(h, a, NULL);
    a = e1432_get_coupling_freq_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_coupling_freq(h, a, f);
    a = e1432_get_duty_cycle(h, a, NULL);
    a = e1432_get_duty_cycle_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_duty_cycle(h, a, f);
    a = e1432_get_enable(h, a, b, NULL);
    a = e1432_set_enable(h, a, b, a);
    a = e1432_get_filter_freq(h, a, NULL);
    a = e1432_get_filter_freq_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_filter_freq(h, a, f);
    a = e1432_get_input_high(h, a, NULL);
    a = e1432_set_input_high(h, a, b);
    a = e1432_get_input_low(h, a, NULL);
    a = e1432_set_input_low(h, a, b);
    a = e1432_get_input_mode(h, a, NULL);
    a = e1432_set_input_mode(h, a, b);
    a = e1432_get_input_offset(h, a, NULL);
    a = e1432_get_input_offset_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_input_offset(h, a, f);
    a = e1432_get_pre_arm_rpm(h, a, NULL);
    a = e1432_get_pre_arm_rpm_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_pre_arm_rpm(h, a, f);
    a = e1432_get_ramp_rate(h, a, NULL);
    a = e1432_get_ramp_rate_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_ramp_rate(h, a, f);
    a = e1432_get_range(h, a, NULL);
    a = e1432_get_range_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_range(h, a, f);
    a = e1432_get_range_charge(h, a, NULL);
    a = e1432_get_range_charge_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_range_charge(h, a, f);
    a = e1432_get_range_mike(h, a, NULL);
    a = e1432_get_range_mike_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_range_mike(h, a, f);
    a = e1432_get_rpm_high(h, a, NULL);
    a = e1432_get_rpm_high_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_rpm_high(h, a, f);
    a = e1432_get_rpm_interval(h, a, NULL);
    a = e1432_get_rpm_interval_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_rpm_interval(h, a, f);
    a = e1432_get_rpm_low(h, a, NULL);
    a = e1432_get_rpm_low_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_rpm_low(h, a, f);
    a = e1432_get_rpm_smoothing(h, a, NULL);
    a = e1432_get_rpm_smoothing_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_rpm_smoothing(h, a, f);
    a = e1432_get_sine_freq(h, a, NULL);
    a = e1432_get_sine_freq_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_sine_freq(h, a, f);
    a = e1432_get_sine_phase(h, a, NULL);
    a = e1432_get_sine_phase_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_sine_phase(h, a, f);
    a = e1432_get_source_blocksize(h, a, NULL);
    a = e1432_get_source_blocksize_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_source_blocksize(h, a, l);
    a = e1432_get_source_centerfreq(h, a, NULL);
    a = e1432_get_source_centerfreq_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_source_centerfreq(h, a, f);
    a = e1432_get_source_cola(h, a, NULL);
    a = e1432_set_source_cola(h, a, b);
    a = e1432_get_source_mode(h, a, NULL);
    a = e1432_set_source_mode(h, a, b);
    a = e1432_get_source_output(h, a, NULL);
    a = e1432_set_source_output(h, a, b);
    a = e1432_get_source_seed(h, a, NULL);
    a = e1432_get_source_seed_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_source_seed(h, a, b);
    a = e1432_get_source_span(h, a, NULL);
    a = e1432_get_source_span_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_source_span(h, a, f);
    a = e1432_get_source_sum(h, a, NULL);
    a = e1432_set_source_sum(h, a, b);
    a = e1432_get_srcbuffer_init(h, a, NULL);
    a = e1432_set_srcbuffer_init(h, a, b);
    a = e1432_get_srcbuffer_mode(h, a, NULL);
    a = e1432_set_srcbuffer_mode(h, a, b);
    a = e1432_get_srcbuffer_size(h, a, NULL);
    a = e1432_get_srcbuffer_size_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_srcbuffer_size(h, a, l);
    a = e1432_get_srcparm_mode(h, a, NULL);
    a = e1432_set_srcparm_mode(h, a, l);
    a = e1432_get_srcoff_mode(h, a, NULL);
    a = e1432_set_srcoff_mode(h, a, b);
    a = e1432_get_tach_decimate(h, a, NULL);
    a = e1432_get_tach_decimate_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_tach_decimate(h, a, b);
    a = e1432_get_tach_holdoff(h, a, NULL);
    a = e1432_get_tach_holdoff_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_tach_holdoff(h, a, f);
    a = e1432_get_tach_irq_number(h, a, NULL);
    a = e1432_get_tach_irq_number_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_tach_irq_number(h, a, b);
    a = e1432_get_tach_max_time(h, a, NULL);
    a = e1432_get_tach_max_time_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_tach_max_time(h, a, f);
    a = e1432_get_tach_ppr(h, a, NULL);
    a = e1432_get_tach_ppr_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_tach_ppr(h, a, f);
    a = e1432_get_trigger_channel(h, a, NULL);
    a = e1432_set_trigger_channel(h, a, b);
    a = e1432_get_trigger_level(h, a, b, NULL);
    a = e1432_get_trigger_level_limits(h, a, b, NULL, NULL, NULL, NULL);
    a = e1432_set_trigger_level(h, a, b, f);
    a = e1432_get_trigger_mode(h, a, NULL);
    a = e1432_set_trigger_mode(h, a, b);
    a = e1432_get_trigger_slope(h, a, NULL);
    a = e1432_set_trigger_slope(h, a, b);
    a = e1432_get_weighting(h, a, NULL);
    a = e1432_set_weighting(h, a, b);

    /* Short cuts */
    a = e1432_preset(h, a);
    a = e1432_set_analog_input(h, a, b, a, a, a, f);
    a = e1432_set_data_format(h, a, l, a, a, a);
    a = e1432_set_interrupt(h, a, b, a);
    a = e1432_set_trigger(h, a, b, l, f, f, a, a);
    a = e1432_get_ttltrg_lines(h, a, NULL);
    a = e1432_set_ttltrg_lines(h, a, b);

    /* Group setups */
    a = e1432_assign_channel_numbers(a, NULL, &h);
    a = e1432_assign_channels(a, NULL, &h, i);
    a = e1432_channel_group_add(h, a, b);
    a = e1432_channel_group_remove(h, a, b);
    a = e1432_create_channel_group(h, a, NULL);
    a = e1432_delete_all_chan_groups(h);
    a = e1432_delete_channel_group(h, a);
    a = e1432_get_fwrev(NULL, NULL);
    a = e1432_get_group_info(h, a, b, NULL, a);
    a = e1432_get_hwconfig(a, NULL, &hwconfig);
    a = e1432_init_io_driver();
    a = e1432_install_file(i1432_mod_opt_list, a);
    a = e1432_install(a, (SHORTSIZ16 *) &i1432_diag_config, l, "");
    a = e1432_set_interface_addr("");
    a = e1432_uninit_io_driver();

    /* Actions */
    a = e1432_arm_measure(h, a, a);
    a = e1432_arm_measure_master_finish(h, a);
    a = e1432_arm_measure_master_setup(h, a);
    a = e1432_arm_measure_slave_finish(h, a);
    a = e1432_auto_range(h, a, d);
    a = e1432_auto_zero(h, a);
    a = e1432_cached_parm_update(h, a);
    a = e1432_finish_measure(h, a);
    a = e1432_init_measure(h, a);
    a = e1432_init_measure_finish(h, a, a);
    a = e1432_init_measure_master_finish(h, a, a);
    a = e1432_init_measure_master_setup(h, a, a);
    a = e1432_init_measure_slave_finish(h, a);
    a = e1432_init_measure_slave_middle(h, a);
    a = e1432_init_measure_slave_setup(h, a);
    a = e1432_init_measure_to_booted(h, a, a);
    a = e1432_pre_arm_measure(h, a, a);
    a = e1432_read_i2c(h, a, a, NULL);
    a = e1432_reenable_interrupt(h, a);
    a = e1432_reset(h, a);
    a = e1432_reset_measure(h, a);
    a = e1432_selftest(a, NULL, a, NULL);
    a = e1432_send_tachs(h, a, b, NULL, i, NULL);
    a = e1432_send_trigger(h, a);
    a = e1432_test_lbus(h, a, b);
    a = e1432_trigger_measure(h, a, a);
    a = e1432_write_i2c(h, a, a, a);
    a = e1432_update_srcparm(h, a, l);
    a = e1432_zap(a, a, l, &l);
    a = e1432_zap_src_boot(a, a, a, "");

    /* Results */
    a = e1432_check_overloads(h, a, NULL, NULL, NULL, NULL);
    a = e1432_get_cvt_data(h, a, NULL, l);
    a = e1432_get_raw_tachs(h, a, NULL, l, NULL);
    a = e1432_get_samples_to_pre_arm(h, a, NULL);
    a = e1432_get_trig_corr(h, a, NULL);
    a = e1432_read_raw_data(h, a, a, NULL, l, NULL, NULL);
    a = e1432_read_float32_data(h, a, a, NULL, l, NULL, NULL);
    a = e1432_read_float64_data(h, a, a, NULL, l, NULL, NULL);
    a = e1432_write_srcbuffer_data(h, a, NULL, l, a);
    a = e1432_check_spectrum(h, a, a);
    a = e1432_request_spectrum(h, a, f, l, l, a, a);
    a = e1432_read_float32_spectrum(h, a, NULL, l, NULL, NULL);
    a = e1432_read_float64_spectrum(h, a, NULL, l, NULL, NULL);

    /* General inquiry */
    a = e1432_check_src_arbrdy(h, a, a);
    a = e1432_check_src_overload(h, a);
    a = e1432_check_src_overread(h, a);
    a = e1432_check_src_shutdown(h, a);
    a = e1432_check_src_underrun(h, a);
    a = e1432_block_available(h, a);
    a = e1432_get_blocksize_current_max(h, a, NULL);
    a = e1432_get_current_peak(h, a, NULL);
    a = e1432_get_current_rms(h, a, NULL);
    a = e1432_get_current_rpm(h, a, NULL);
    a = e1432_get_current_value(h, a, a, NULL);
    a = e1432_get_data_rpm(h, a, NULL);
    a = e1432_get_decimation(h, a, NULL);
    a = e1432_get_fifo_size_current_max(h, a, NULL);
    a = e1432_get_meas_state(h, a, NULL);
    a = e1432_get_meas_warning(h, a, NULL, l, NULL);
    a = e1432_get_next_arm_rpm(h, a, NULL);
    a = e1432_get_register_address(h, a, b, NULL);
    a = e1432_get_scale(h, a, NULL);
    a = e1432_get_src_arbstates(h, a, NULL, NULL, NULL, NULL);
    a = e1432_get_tach_clock_freq(h, a, NULL);
    a = e1432_get_tach_delay(h, a, NULL);

    /* Undocumented inquiry */
    a = e1432_get_cal_failures(h, a, NULL);
    a = e1432_get_cal_gain(h, a, NULL);
    a = e1432_get_cal_gain2(h, a, NULL);
    a = e1432_get_cal_offset(h, a, NULL);
    a = e1432_get_cal_offset2(h, a, NULL);

    /* Custom SCA */
    a = e1432_dsp_exec_query(h, a, l, l, NULL, l, NULL);
    a = e1432_sca_dsp_download(h, a, l, NULL);
    a = e1432_set_user_data(h, a, l, a, a, a);
    a = e1432_src_get_fwrev(NULL, NULL, NULL, l);
    a = e1432_src_get_rev(h, a, NULL, NULL, NULL, "");
    a = e1432_src_prog_romimage(h, a, NULL, l);
    a = e1432_src_rxfr(h, a, l, NULL, l);

    /* Debugging setup */
    e1432_debug_level(a);
    a = e1432_print_errors(a);
    a = e1432_set_diag_print_level(a);
    e1432_set_try_recover(l);
    e1432_trace_level(a);

    /* Debugging */
    a = e1432_display_state(h);
    a = e1432_fill_error_string(p, a, &b);
    a = e1432_get_autozero_offset(h, a, NULL);
    a = e1432_get_autozero_offset_limits(h, a, NULL, NULL, NULL, NULL);
    a = e1432_set_autozero_offset(h, a, f);
    p = e1432_get_error_string();
    p = e1432_get_warning_string(a);
    a = e1432_read_dsp_mem(h, a, b, l, &l);
    a = e1432_read_dsp_port(h, a, b, a, l, &l);
    a = e1432_read_flash(a, a, l, &l);
    a = e1432_read_fw_marker(a, &l);
    a = e1432_read_register(h, a, b, p);
    a = e1432_read32_register(h, a, b, NULL);
    a = e1432_write_dsp_mem(h, a, b, l, l);
    a = e1432_write_dsp_port(h, a, b, a, l, l);
    a = e1432_write_register(h, a, b, a);
    a = e1432_write32_register(h, a, b, l);

    /* Obsolete functions provided for Octane compatibility */
    /* Use e1432_get_span and e1432_set_span to replace these: */
    a = e1432_get_auto_arm(h, a, NULL);
    a = e1432_set_auto_arm(h, a, b);
    a = e1432_get_decimation_bandwidth(h, a, NULL);
    a = e1432_set_decimation_bandwidth(h, a, b);
    /* Use e1432_set_decimation_output, e1432_set_anti_alias_digital, and
       a = e1432_set_span to replace this: */
    a = e1432_set_decimation_filter(h, a, b, a, a);

    return a;
}
